using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.Net;
using System.Net.Mail;

using System.Web.Security;

public partial class Logowanie : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }

    private bool CzytajDaneZBazy(string email,out string haslo,out int wykladID,out StrukturyDanych.Osoba osoba,out StrukturyDanych.Nocleg nocleg,out StrukturyDanych.Wyklad wyklad)
    {
        try
        {
            AccessDataSource ads = new AccessDataSource("App_Data\\Konferencja.mdb", "SELECT * FROM [Osoby] WHERE Email='" + email + "'");
            DataRowView rekord = ((DataView)ads.Select(DataSourceSelectArguments.Empty))[0];
            haslo = (string)rekord["Haslo"];
            osoba = new StrukturyDanych.Osoba();
            osoba.Imie = (string)rekord["Imie"];
            osoba.Nazwisko = (string)rekord["Nazwisko"];
            osoba.Email = (string)rekord["Email"]; //dla weryfikacji
            osoba.InstytucjaNazwa = (string)rekord["InstytucjaNazwa"];
            osoba.InstytucjaAdres1 = (string)rekord["InstytucjaAdres1"];
            osoba.InstytucjaAdres2 = (string)rekord["InstytucjaAdres2"];
            osoba.CzyWyklad = (bool)rekord["CzyWyklad"];

            nocleg = new StrukturyDanych.Nocleg();
            nocleg.Przyjazd = (int)rekord["Przyjazd"];
            nocleg.Wyjazd = (int)rekord["Wyjazd"];
            nocleg.CzyNocleg = (bool)rekord["CzyNocleg"];
            nocleg.CzyWyzywienie = (bool)rekord["CzyWyzywienie"];
            nocleg.TypPokoju = (string)rekord["TypPokoju"];
            nocleg.OsobaTowarzyszaca = (bool)rekord["OsobaTowarzyszaca"];

            if (osoba.CzyWyklad)
            {
                wykladID = (int)rekord["WykladID"];
                ads.SelectCommand = "SELECT * FROM [Wyklady] WHERE WykladID=" + wykladID;
                rekord = ((DataView)ads.Select(DataSourceSelectArguments.Empty))[0];
                wyklad = new StrukturyDanych.Wyklad();
                wyklad.Tytul = (string)rekord["Tytul"];
                wyklad.Mowca = (string)rekord["Mowca"];
                wyklad.PozostaliAutorzy = (string)rekord["PozostaliAutorzy"];
                wyklad.Streszczenie = (string)rekord["Streszczenie"];
            }
            else
            {
                wykladID = 0;
                wyklad = null;
            }
            
            return true;
        }
        catch
        {
            haslo = "";
            wykladID=0;
            osoba=null;
            nocleg=null;
            wyklad=null;

            return false;
        }
    }
    

    protected void Button1_Click(object sender, EventArgs e)
    {
        //Inicjacja mechanizmy uwierzytelniania Forms
        FormsAuthentication.Initialize();

        string haslo;
        int wykladID;
        StrukturyDanych.Osoba osoba;
        StrukturyDanych.Nocleg nocleg;
        StrukturyDanych.Wyklad wyklad;        
        if (CzytajDaneZBazy(TextBox1.Text,out haslo,out wykladID,out osoba,out nocleg,out wyklad))
        {
            //Poprawne haso
            if (TextBox2.Text == haslo)
            {
                Label1.Text = "Dane poprawnie odczytane z bazy";
                Label1.ForeColor = System.Drawing.Color.Black;
                Label2.Text = osoba.Imie + " " + osoba.Nazwisko;
                Label3.Text = nocleg.Przyjazd + " lipca";
                if (wyklad != null) Label4.Text = wyklad.Tytul;
                Session.Add("osoba", osoba);
                Session.Add("nocleg", nocleg);
                Session.Add("wyklad", wyklad);
                TextBox1.Enabled = false;
                TextBox2.Enabled = false;
                Button1.Enabled = false;
                Button2.Enabled = false;
                Button3.Enabled = true;
                Button4.Text = "Wyloguj";
                Session.Add("modyfikowanieDanych", true);
                if (osoba.CzyWyklad) Session.Add("modyfikowanieDanychWykladID", wykladID);
                else Session.Add("modyfikowanieDanychWykladID", 0);

                //Tworzymy bilet, czyli plik cookie
                FormsAuthenticationTicket bilet = new FormsAuthenticationTicket(
                    1, //wersja biletu
                    TextBox1.Text, //e-mail uytkownika
                    DateTime.Now, //data i godzina zaoenia pliku cookie
                    DateTime.Now.AddMinutes(30), //czas wyganicia
                    false, //czy cookie ma by trwae
                    FormsAuthentication.FormsCookiePath); //adres strony

                //Umieszczenie biletu na zdalnym komputerze uytkownika
                HttpCookie cookie = new HttpCookie(
                    FormsAuthentication.FormsCookieName,
                    FormsAuthentication.Encrypt(bilet));
                Response.Cookies.Add(cookie);

                //Automatyczne przeniesienie na stron, do ktrej prbowano uzyska dostp
                if (Request.Params["ReturnUrl"] != null) Response.Redirect(Request.Params["ReturnUrl"]);
            }
            else
            {
                Label1.Text = "Niepoprawne haso";
                Label1.ForeColor = System.Drawing.Color.Red;
                Button3.Enabled = false;
                Button4.Text = "Powrt do strony gwnej";
            }
        }
        else
        {
            Label1.Text = "Podany e-mail nie zosta jeszcze uyty do rejestracji";
            Label1.ForeColor = System.Drawing.Color.Red;
        }
    }

    protected void Button4_Click(object sender, EventArgs e)
    {
        Response.Redirect("Index.aspx");        
    }

    protected void Button3_Click(object sender, EventArgs e)
    {
        Response.Redirect("Formularz.aspx");
    }

    protected void Button2_Click(object sender, EventArgs e)
    {
        string haslo;
        int wykladID;
        StrukturyDanych.Osoba osoba;
        StrukturyDanych.Nocleg nocleg;
        StrukturyDanych.Wyklad wyklad;
        if (CzytajDaneZBazy(TextBox1.Text, out haslo, out wykladID, out osoba, out nocleg, out wyklad))
        {
            string email = TextBox1.Text;
            string serwerSMTP = "smtp.fizyka.umk.pl";
            //string serwerSMTP = "smtp.psk.pl"; //serwer SMTP
            int portSMTP = 25;
            SmtpClient smtp = new SmtpClient(serwerSMTP, portSMTP);
            smtp.Credentials = CredentialCache.DefaultNetworkCredentials;
            MailMessage list = new MailMessage("konferencja@psk.pl", email);
            list.Subject = "Haso logowania na stron III Krajowej Konferencji klimatologw";
            list.IsBodyHtml = true;
            list.Body = "Zarejestrowana osoba: <FONT COLOR=DarkGreen>" + osoba.Imie + " " + osoba.Nazwisko + "</FONT><BR>Haso: <FONT COLOR=blue>" + haslo + "</FONT>";
            smtp.Send(list);

            Label1.Text = "Haso zostao wysane na podany adres";
            Label1.ForeColor = System.Drawing.Color.DarkGreen;
        }
        else
        {
            Label1.Text = "Podany e-mail nie zosta jeszcze uyty do rejestracji";
            Label1.ForeColor = System.Drawing.Color.Red;
        }
    }
}
